package com.aimms.aimmssdk.examples.views;

import com.aimms.aimmssdk.AIMMS;
import com.aimms.aimmssdk.AimmsException;
import com.aimms.aimmssdk.ISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {

    static private Logger logger = LoggerFactory.getLogger(Main.class);

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        if (args.length != 2) {
            logger.error("Invalid number of arguments. usage: <location of AIMMS> <location of project>");
            return;
        }

        ISession session = null;

        try {
            logger.info("opening project");
            session = AIMMS.openSession(args[0], args[1]);
            if (session == null) {
                return;
            }

            Views views = new Views(session);

            views.setLabels();
            views.setValues();
            views.createViews();
            views.assignToViews();
            views.readFiltered();


        } catch (AimmsException ae) {
            logger.error("main: AIMMS exception:", ae);
        } catch (Exception e) {
            logger.error("main: exception:", e);
        } finally {
            if (session != null) {
                logger.info("closing project");
                session.clearBuffers(); // discards all buffered modifications, without this call close is slower and may throw.
                session.close();
            }
        }
    }
}
