package com.aimms.aimmssdk.examples.pitfalls;

import com.aimms.aimmssdk.ISession;
import com.aimms.aimmssdk.ISetData;
import com.aimms.aimmssdk.ISetIterator;

/**
 * This example demonstrates some easily made mistakes using the SDK.
 */
class Pitfalls {

    ISession m_Session;

    public Pitfalls(ISession session) {
        m_Session = session;
    }

    /**
     * Using set ordering. The SDK uses only the 'natural' Aimms ordering, which
     * is the creation order of the labels. See also the section on "Set element
     * ordering" in the Execution Efficiency Cookbook chapter in the Aimms
     * Language Reference.
     */
    public void useOrdinals() {
        ISetData setCustomers = m_Session.openSet("Customers");
        setCustomers.add("Oslo");
        setCustomers.add("Madrid");

        // If the root set was completely empty until now, the order will be as expected.
        ISetIterator itCustomers = setCustomers.createIterator();
        itCustomers.next();
        assert ("Oslo" == itCustomers.element().getLabel());
        itCustomers.next();
        assert ("Madrid" == itCustomers.element().getLabel());


        ISetData setDepots = m_Session.openSet("Depots");
        setDepots.add("London");
        setDepots.add("Oslo");

        // Since Depots and Customers share a rootset (Locations), 
        // "Oslo" was added to the rootset before "London".
        // It will be the first Depot!
        ISetIterator itDepots = setDepots.createIterator();
        itDepots.next();
        assert ("Oslo" == itDepots.element().getLabel());
        itDepots.next();
        assert ("London" == itDepots.element().getLabel());
    }

    /**
     * Writing sets. Set write actions are recursive: - adding a label to a subset
     * will also add it to the superset - deleting a label from a set will also
     * delete it from its subsets, - emptying a set will empty all its subsets.
     * - setLabels() has an implicit empty, therefore setLabels empties all the
     * subsets
     */
    public void initializeSets() {
        // the data:
        String[] locations = {"London", "Oslo", "Madrid"};
        String[] customers = {"Oslo", "Madrid"};
        String[] depots = {"London", "Oslo"};

        // adding the data incorrectly:
        {
            ISetData setCustomers = m_Session.openSet("Customers");
            setCustomers.setLabels(customers); // This will also add Oslo and Madrid to the superset Locations.
            ISetData setDepots = m_Session.openSet("Depots");
            setDepots.setLabels(depots); // This will also add London to the superset Locations, the others were already present.
            ISetData setLocations = m_Session.openSet("Locations");
            setLocations.setLabels(locations); // This will empty the set and its subsets, and then adds London and Oslo to only itself.

            assert (setDepots.getCardinality() == 0); // Probably not intended.
        }
    }
}
