package com.aimms.aimmssdk.examples.performance;

import com.aimms.aimmssdk.AIMMS;
import com.aimms.aimmssdk.AimmsException;
import com.aimms.aimmssdk.ISession;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {

    static private Logger logger = LoggerFactory.getLogger(Main.class);

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        if (args.length != 2) {
            logger.error("Invalid number of arguments. usage: <location of AIMMS> <location of project>");
            return;
        }
       
        String[] labels = {"ab", "ac", "ad", "ae", "ah", "ai", "al", "am", "an", "ar", "as", "at", "aw", "ax", "ay", "aah", "aam", "abb", "abc", "abo", "abs", "abt", "aby", "ace", "ach", "act", "add", "adj", "ado", "ads", "adv", "adz", "afb", "aft", "aga", "age", "ago", "aha", "ahs", "ahu", "aid", "ail", "aim", "air", "ais", "ait", "ake", "ala", "alb", "ale", "all", "alp", "als", "alt", "ama", "amp", "amt", "amu", "amy", "ana", "and", "ani", "ann", "ano", "ant", "any", "ape", "apo", "app", "apt", "ara", "arc", "are", "arf", "ark", "arm", "ars", "art", "asa", "ash", "ask", "asp", "ass", "ate", "aud", "auf", "auk", "aum", "aux", "ava", "ave", "avg", "awe", "awk", "awl", "awm", "awn", "axe", "aye", "aahs", "abay", "abba", "abbe", "abbr", "abed", "abet", "abib", "abid", "abit", "able", "ably", "abox", "abra", "abut", "abye", "acct", "aced", "aces", "ache", "achy", "acid", "aclu", "acme", "acne", "acre", "acts", "acyl", "adam", "adar", "adaw", "adds", "adit", "ados", "adry", "advt", "adze", "aeon", "aero", "aery", "afar", "afer", "affy", "afro", "agar", "aged", "agen", "ages", "agha", "agin", "agio"};

        Performance test = new Performance(args[0], args[1], labels);
        try {
            
            test.convenientAssignLabels();
            test.efficientAssignLabels();
            test.denseAssignLabels();
            test.sliceAssignLabels();
            test.filteredAssignLabels();
            
        } catch (AimmsException ae) {
            logger.error("main: AIMMS exception:", ae);
        } catch (Exception e) {
            logger.error("main: exception:", e);
        } 
    }
}
