
package com.aimms.aimmssdk.examples.basic;


import com.aimms.aimmssdk.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
This basic example demonstrates the code to 
- Set up the connection to a model, 
- Assign parameter data, 
- Solve the model,
- Retrieve variables
*/
class Basic {
    static private Logger logger = LoggerFactory.getLogger(Basic.class);

    static void setParameters(ISession session) {
        // Use the insert method to add labels to the domain sets while adding data.

        // Set supply.
        IMultiDimData parameterSupply = session.openMultiDim("Supply");
        parameterSupply.insert(new Tuple("London"),20.0);
        parameterSupply.insert(new Tuple("Paris"),30.0);

        // Close data if it is no longer needed.
        parameterSupply.close();

        // Set demand.
        IMultiDimData parameterDemand = session.openMultiDim("Demand");
        parameterDemand.insert(new Tuple("Oslo"),10.0);
        parameterDemand.insert(new Tuple("Madrid"),15.0);
        parameterDemand.insert(new Tuple("Berlin"),20.0);
        parameterDemand.close();

        // Use the setValue method to add data without expanding the domain sets.
        // An error will be generated if a label does not exist in the domain.

        // Set transportcosts.
        IMultiDimData parameterUnitTransportCost = session.openMultiDim("UnitTransportCost");
        try{
            parameterUnitTransportCost.setValue(new Tuple("London","Oslo"),7.0);
            parameterUnitTransportCost.setValue(new Tuple("London","Madrid"),12.0);
            parameterUnitTransportCost.setValue(new Tuple("London","Berlin"),18.0);
            parameterUnitTransportCost.setValue(new Tuple("Paris","Oslo"),14.0);
            parameterUnitTransportCost.setValue(new Tuple("Paris","Madrid"),23.0);
            parameterUnitTransportCost.setValue(new Tuple("Paris","Berlin"),17.0);
        }catch(AimmsRuntimeException ex){
            logger.error("Catched a runtime exception: {}", ex.getMessage());
        }
        parameterUnitTransportCost.close();
    }

    static void runMainExecution(ISession session) {
        // Retrieve the procedure.
        IProcedure procedure = session.openProcedure("MainExecution");

        // Run the procedure.
        procedure.run();

        // Close it afterwards. 
        procedure.close();
    }

    static void retrieveVariables(ISession session) {
        // Retrieve and display the scalar variable TotalCost.
        // Scalars have their own interface, and are retrieved with the openScalar method.
        IScalarData variableTotalCost = session.openScalar("TotalCost");

        double totalcost = variableTotalCost.asDouble();

        logger.info("{} : {}", variableTotalCost.getName(), totalcost );

        variableTotalCost.close(); 

        // Retrieve and display the two dimensional variable Transport.
        IMultiDimData variableTransport = session.openMultiDim("Transport");

        // To access multidimensional data, use an iterator.
        IIterator it = variableTransport.createIterator();

        logger.info("{}:", variableTransport.getName());
        while (it.next()) {  // iterate through all by calling next successively

            // The tuple method gives access to the current position. 
            // The asDouble method returns the value at the current position.
            logger.info("  {} : {} ", it.tuple(), it.asDouble() );
        }

        variableTransport.close(); // Closing  an IMultiDimData closes all its open iterators as well.
    }
}
