#ifndef _INCLUDE_aimms_Tuple
#define _INCLUDE_aimms_Tuple

#include <string>
#include <vector>
#include "aimms/Exception.h"

namespace aimms {

           
    /* Object that allows to conveniently represent an AIMMS tuple.
       Use the ITuple inerface instead when performance is an issue, or when
       the convenience Tuple, which has a maximum of 5 dimensions,
       is not enough.
       
       Convenience tuples can be created using the constructors,
       which allow up to 5 labels as argument.                      */
    class Tuple
    {
    public:
        class TupleArg;

        /* Create a tuple with a various number of integers and / or
           strings.                                                  */
        Tuple() : m_nDimension(0){
        }
        Tuple( const TupleArg& arg1 ) : m_nDimension(1){
            m_Args[0]=arg1;
        }
        Tuple( const TupleArg& arg1, const TupleArg& arg2) : m_nDimension(2){
            m_Args[0]=arg1;
            m_Args[1]=arg2;
        }
        Tuple( const TupleArg& arg1, const TupleArg& arg2, const TupleArg& arg3): m_nDimension(3){
            m_Args[0]=arg1;
            m_Args[1]=arg2;
            m_Args[2]=arg3;
        }
        Tuple( const TupleArg& arg1, const TupleArg& arg2, const TupleArg& arg3, const TupleArg& arg4 ): m_nDimension(4){
            m_Args[0]=arg1;
            m_Args[1]=arg2;
            m_Args[2]=arg3;
            m_Args[3]=arg4;
        }
        Tuple( const TupleArg& arg1, const TupleArg& arg2, const TupleArg& arg3, const TupleArg& arg4, const TupleArg& arg5 ): m_nDimension(5){
            m_Args[0]=arg1;
            m_Args[1]=arg2;
            m_Args[2]=arg3;
            m_Args[3]=arg4;
            m_Args[4]=arg5;
        }


    public:
        /* Argument of a Tuple, can be integer or string typed. */
        class TupleArg
        {
            friend class Tuple;
        public:
            TupleArg(const char* label)
                : m_type(strlabel)
                , m_s(label)
            {
            }

            TupleArg(int label)
                : m_type(intlabel)
                , m_i(label)
            {
            }

            TupleArg(const TupleArg& other)
                : m_type(other.m_type)
            {
                switch(m_type){
                case strlabel : m_s = other.m_s;break;
                case intlabel : m_i = other.m_i;break; 
                }
            }
            enum type{
                intlabel = 0, 
                strlabel = 1
            };
            type m_type;

            union{
                const char* m_s;
                int         m_i;
            };

        protected:
            TupleArg(){}; // ctor needed for array of TupleArgs in Tuple
        };

    public:
        /* Returns the dimension of the Tuple.*/ 
        int getDimension() const {
            return m_nDimension;
        }
        /* Returns the TupleArg on the requested level. */
        const TupleArg& getArg(int level) const{
            if(level >= m_nDimension || level < 0){
                throw InvalidUseException("argument out of bounds");
            }
            return m_Args[level];
        }

    private:
        int m_nDimension;
        TupleArg m_Args[5];

    };

}

#endif
