#ifndef _INCLUDE_aimms_ISetIterator
#define _INCLUDE_aimms_ISetIterator

namespace aimms{

	class IElement;

	/* An object that allows you to iterate over the data associated
	   with an ISetData object.
	   
	   Set iterators can be created using createIterator on an
	   ISetData.                                                     */
	class ISetIterator 
	{
	protected:
		/* use close */
		virtual ~ISetIterator(){}

	public:
        /**
         * Closes the iterator and invalidates the object.
         */
        virtual void close()=0;

        /**
         * Verifies whether the IElement is compatible with the rootset of the
         * ISetData to which this iterator belongs.
         *
         * @param element The IElement to be tested for compatibility.
         * @return True if the element is compatible.
         */
        virtual bool elementCompatible(const IElement*) = 0;

        /* Re initializes the iterator: Moves the current position to
           before the beginning of the data; a subsequent next call will
           find the first element. If the iterator was in an erroneous
           state, the reset method will also reset the state to normal.  */
        virtual void reset()=0;

        /**
         * Moves the current iterator position to the next iterator position, if
         * any.
         *
         * @return False if the end of the data is reached, true otherwise.
         */
        virtual bool next()=0;

        /**
         * Creates an IElement to be used with the getElement method.
         *
         * @return An IElement to be used with the getElement method.
         */		
		virtual IElement* createElement() = 0;

        /**
         * Gets the element associated with the current iterator position.
         *
         * @param pos The IElement to which the element associated with the current
         * iterator position will be assigned.
         */
        virtual void getElement(IElement* pos)=0;
	
        /**
         * Returns an IElement associated with the current iterator position.
         *
         * @return An IElement associated with the current iterator position.
         */
		virtual const IElement* element() const = 0;
	};
};

#endif // #ifndef _INCLUDE_aimms_ISetIterator
