#ifndef _INCLUDE_aimms_IScalarDataView
#define _INCLUDE_aimms_IScalarDataView

#include "aimms/IDataView.h"
#include "aimms/IScalarData.h"

namespace aimms{


    /* Represents a scalar/zero-dimensional view on data.
       
       Views can be created using openView on an IMultiDimData. This
       method requires a filter that can be created using
       createFilter (on the IMultiDimData).
       
       If the resulting IDataView has dimension of zero, it can be
       cast to an IScalarDataView to gain access to more convenient
       methods for accessing the scalar data.                        */
    class IScalarDataView : virtual public IScalarData, virtual public IDataView
    {
    private:
        IScalarDataView( const IScalarDataView& ) = delete;
        IScalarDataView& operator = ( const IScalarDataView& ) = delete;
    protected:
		IScalarDataView(){}
		/* Use close() to destroy the object */
		virtual	~IScalarDataView(){}

    public:
        using IScalarData::setValue;
        using IDataView::setValue;
        using IScalarData::createElementValue;
    };

}

#endif
