#ifndef _INCLUDE_aimms_IMultiDimData
#define _INCLUDE_aimms_IMultiDimData

#include "aimms/IDataView.h"
#include "aimms/IFilter.h"

namespace aimms{

	class ITuple;
    class Tuple;
    class ISetData;
        
   /* An object that represents the data of a multi-dimensional
      identifier in the AIMMS model.
      
      Non-scalar data objects can be created using openMultiDim on
      the ISession.                                                */
    class IMultiDimData : virtual  public IDataView
	{
    private:
        // disallow copy and assign
        IMultiDimData( const IMultiDimData& );
        IMultiDimData& operator = ( const IMultiDimData& );
	protected:
        IMultiDimData(){};
		/* Use close() to destroy the object. */
		virtual ~IMultiDimData(){};

    public:

       /* Creates an iterator to iterate through the filtered data. By
          default, 100 tuples are cached.
          
          The identifier is cleaned up upon creation of the iterator.
          
          
          
          Also initializes the iterator: Moves the current position to
          before the beginning of the data; a subsequent next call will
          find the first non-default position.
          @param tuplesAhead  The amount of tuples to cache. 
          @param filter       The filter over the data. 
          @return The iterator.                                         */                                                     
        virtual class IIterator* createIterator(IFilter* filter, int tuplesAhead = 100) = 0;

        /**
        * Creates an iterator to iterate through the filtered data. By
        * default, 100 tuples are cached.
        *
        * Also initializes the iterator: Moves the current position to
        * before the beginning of the data; a subsequent next call will
        * find the first non-default position.
        * @param tuplesAhead The amount of tuples to cache.
        * @return The iterator.
        */     
        virtual class IIterator* createIterator(int tuplesAhead = 100) = 0;

        /**
         * Opens an IDataView on this multidimensional data.
         *
         * @param filter The filter that restricts the view to create.
         * @return The IDataView.
         */
        virtual IDataView* openView(IFilter* filter) = 0;

        /**
         * Creates an IFilter based on the index domains of this data, such that it
         * can be used with the openView and/or createIterator methods.
         *
         * @return A new instance of IFilter.
         */
        virtual IFilter* createFilter() = 0;

        /**
         * Synchronizes this data with the corresponding identifier in the AIMMS
         * model. Flushes all modifications (including the index domains) on this
         * data and all its views and waits for it to finish.
         */
        virtual void sync() = 0;

	};
};

#endif // #ifndef _INCLUDE_aimms_IMultiDimData
