#ifndef _INCLUDE_aimms_IData
#define _INCLUDE_aimms_IData

#include "aimms/IAimmsObject.h"
#include <string>

namespace aimms{


    //Aimms data types
	enum DataType {
		tMultiDimensional,
		tSet,
		tScalar
	};

    //Aimms value types
	enum ValueType{
		vtDouble, 
		vtInteger, 
		vtElement,
		vtString,
		vtBool
	};

	class IElement;

	/* Base class that represents an AIMMS identifier that holds
	   data.
	   
	   Data objects can be created on the ISession, using openData,
	   openSet, openScalar or openMultiDim.                         */
	class IData : virtual public IAimmsObject
	{
    private:
        // disallow copy and assign
        IData( const IData& );
        IData& operator = ( const IData& );
	protected:
        IData(){};
		/* Use close() to destroy the object. */
		virtual ~IData(){};
	public:
		
        /**
         * Returns the DataType corresponding with the type of this instance of
         * IData (IMultiDimData, ISetData or IScalarData).
         *
         * @return The DataType.
         */
		virtual DataType getType() const = 0;

        /**
         * Returns the ValueType of the data (double, int, IElement, String or
         * boolean).
         *
         * @return The ValueType.
         */
        virtual ValueType getValueType() const = 0;	

        /**
         * \Returns the dimension of the data.
         *
         * @return The dimension.
         */
		virtual int getDimension() const = 0;

        /**
         * \Returns the current number of non-default values of the data.
         *
         * @return The cardinality.
         */
		virtual int getCardinality() const = 0;

        /**
         * Empties the data and resets all pending errors.
         */
		virtual void empty() = 0;
	};
};

#endif // #ifndef _INCLUDE_aimms_IData
