#ifndef _INCLUDE_aimms_ICallBack
#define _INCLUDE_aimms_ICallBack

#include <vector>
#include "AimmsMessage.h"

namespace aimms{

   /*
    * Receiver of information and errors. Can be used to override the default error
    * handling with the setCallBack method of ISession.
    *
    * ICallback creation requires the creation of an instance of your own derived
    * class.
    */                                
    class ICallBack 
	{
	protected:
		virtual ~ICallBack(){}
    public:
        /**
         * Implement this method to receive notifications of errors and other
         * messages.
         *
         * @param messages Collection of AimmsMessage objects.
         */
        virtual void onMessages(std::vector<AimmsMessage>& messages ) = 0;
	};
};

#endif // #ifndef _INCLUDE_aimms_ICallBack
