#ifndef _INCLUDE_aimms_IAimmsObject
#define _INCLUDE_aimms_IAimmsObject


namespace aimms{

    /**
     * Base class for all objects representing an AIMMS identifier in the SDK.
     */
	class IAimmsObject
	{
    private:
        // disallow copy and assign
        IAimmsObject( const IAimmsObject& );
        IAimmsObject& operator = ( const IAimmsObject& );   
	protected:
        IAimmsObject(){};
		/* Use close() to destroy the object. */
		virtual ~IAimmsObject(){}
	public:
        /**
         * \Returns the fully qualified name of the associated identifier in the
         * model.
         *
         * @return The fully qualified name of the associated identifier in the
         * model.
         */
		virtual const char* getName() const = 0;

        /**
         * Closes the reference and invalidates the object.
         */
		virtual void close() = 0;
	};
};

#endif // #ifndef _INCLUDE_aimms_IAimmsObject
