#ifndef _INCLUDED__rapi4cxx_Exception
#define _INCLUDED__rapi4cxx_Exception

#include "aimms/ImportExport.h"
#include "aimms/AimmsMessage.h"


#include <stdexcept>

namespace aimms {

#ifdef _MSC_VER
    //warning C4275: non dll-interface class 'std::runtime_error' used as base for dll-interface class 'rapi4cxx::Exception'
#pragma warning (disable :4275)
#endif

    /* General exception thrown by the SDK. */
    class AIMMSSDK_API Exception : public std::runtime_error 
    {
    public:
        /**
         * Constructs a new Exception with the specified code and message.
         *
         * @param code The AimmsMessageCode specifies the category of the exception.
         * The code can be obtained by invoking the which() method.
         * @param szErrorMessage The detailed message. The detailed message can be obtained
         * by invoking the what() method.
         */
        Exception(AimmsMessageCode code, const char* szErrorMessage);

        /**
         * The AimmsMessageCode indicating the category of the exception.
         *
         * @return The AimmsMessageCode.
         */
        AimmsMessageCode which() const;

    private:
        AimmsMessageCode m_code;
    };



    /**
     * Exception thrown by the SDK for runtime errors generated by AIMMS. Depending
     * on the specific runtime error, continuing your application may produce
     * invalid results.
     */
    class AIMMSSDK_API RuntimeException : public Exception
    {
    public:
        /**
         * Constructs a new RuntimeException with the specified message.
         *
         * @param szErrorMessage The detailed message. The detailed message can be obtained
         * by invoking the what() method.
         */
        RuntimeException(const char* szErrorMessage);
    };

    /**
     * Exception thrown by SDK when a logical model error occurs. For example, when
     * using an element where a double is expected.
     */
    class AIMMSSDK_API InvalidUseException : public Exception
    {
    public:
        /**
         * Constructs a new InvalidUseException with the specified message.
         *
         * @param szErrorMessage The detailed message. The detailed message can be obtained
         * by invoking the what() method.
         */
        InvalidUseException(const char* szErrorMessage);
    };



    /**
     * Exception thrown by the SDK when no valid AIMMS license can be obtained.
     */
    class AIMMSSDK_API LicenseException : public Exception
    {
    public:
        /**
         * Constructs a new LicenseException with the specified message.
         *
         * @param szErrorMessage The detailed message. The detailed message can be obtained
         * by invoking the what() method.
         */
        LicenseException(const char* szErrorMessage);
    };

    /**
     * Exception thrown by the SDK to indicate a communication error with the AIMMS
     * host process.
     */
    class AIMMSSDK_API CommunicationException : public Exception
    {
    public:
        /**
         * Constructs a new CommunicationException with the specified message.
         *
         * @param szErrorMessage The detailed message. The detailed message can be obtained
         * by invoking the what() method.
         */
        CommunicationException(const char* szErrorMessage);
    };



};
// end namespace ARMI

#endif // end #ifndef _INCLUDED__rapi4cxx_Exception
