#ifndef _INCLUDE_aimms_AimmsMessage
#define _INCLUDE_aimms_AimmsMessage

#include <string>

namespace aimms{

	/* Type of message */
	enum AimmsMessageCode{
        /**
         * No errors, no messages.
         */
        AM_OK = 0,
        /**
         * Information.
         */
        AM_Info = 1,
        /**
         * Warning.
         */
		AM_Warning,
        /**
         * A running procedure has been aborted
         */
        AM_Aborted,
        /**
         * An error has occurred due to the run time data, but except for the fact
         * that the last call could not be performed, no damage is done.
         */
        AM_InvalidUse,
        /*
         * An error has occurred due to the runtime data. Depending on the specific
         * runtime error, continuing your application may produce invalid results.
         */
		AM_Runtime,
        /*
         * An error has occurred in the AIMMS project; the internal state can not be
         * guaranteed. More information can be found in the regular AIMMS error documentation.
         */
        AM_General, 
        /**
         * Something went wrong while waiting for an answer from the server.
         */
        AM_Communication,
        /**
         * Something is wrong with the AIMMS License.
         */
        AM_License,
        /**
         * Unexpected internal error.
         */
   		AM_Internal
	};

    /**
     * Object used to pass messages from the SDK and the underlying AIMMS model to
     * the client application.
     */
    struct AimmsMessage{
        /**
         * The AimmsMessageCode indicating the category of the message.
         */
		AimmsMessageCode code;

        /**
         * String representing the message.
         */
        std::string message;
	};
};

#endif // #ifndef _INCLUDE_aimms_AimmsMessage
