#ifndef _INCLUDE_aimms_AIMMS
#define _INCLUDE_aimms_AIMMS

#include "aimms/ImportExport.h"
#include "aimms/ISession.h"
#include "aimms/IConfig.h"
#include <memory>

/**
 * The main factory methods that create the ISession or IConfig objects.
 */
namespace aimms {
        /**
         * Creates an ISession object that represents the specified AIMMS model,
         * using a user-specified configuration.
         *
         * @param szAimmsLocation The location URI of where to start or connect to
         * AIMMS.
         * @param szProjectLocation The AIMMS project file (.prj) to open.
         * @param sessionConfig The IConfig to use.
         * @return The created ISession object.
         */
        AIMMSSDK_API extern ISession* openSession(
            const char* szAimmsLocation,
            const char* szProjectLocation,
            IConfig* sessionConfig);


        /**
         * Creates an IConfig, with all members on default. It can be used,
         * potentially modified, to open a session with a different configuration.
         *
         * @return The created IConfig.
         */
        AIMMSSDK_API extern IConfig* createDefaultConfig();

        /**
         * Creates an ISession object that represents the specified AIMMS model,
         * using the default configuration.
         *
         * @param szAimmsLocation The location URI of where to start or connect to
         * AIMMS.
         * @param szProjectLocation The AIMMS project file (.prj) to open.
         * @return The created ISession object.
         */
        inline ISession* openSession(
            const char* szAimmsLocation,
            const char* szProjectLocation)
        {
            std::unique_ptr<IConfig> config( createDefaultConfig() );
            return openSession(szAimmsLocation, szProjectLocation, config.get() );
        }

		/**
		 * Creates an ISession object that represents the specified AIMMS model,
		 * using a user-specified configuration.
		 *
		 * @param szAimmsLocation The location URI of where to start or connect to
		 * AIMMS.
		 * @param szProjectLocation The AIMMS project file (.prj) to open.
		 * @param sessionConfig The IConfig to use.
		 * @param szConnectOptions The optional extra connect options to use.
		 * @return The created ISession object.
		 */
		AIMMSSDK_API extern ISession* openSessionExt(
			const char* szAimmsLocation,
			const char* szProjectLocation,
			IConfig* sessionConfig,
			const char* szConnectOptions);

	
};

#endif // #ifndef _INCLUDE_aimms_AIMMS
